`timescale 100ps / 10ps

/*
 * Options for modeling byte transmission (uncomment at most 1)
 * - SUHDCHK_ZHD
 *   - Line is released (data=HiZ) after hold time
 * - SUHDCK_CKFE
 *   - Data is set during falling edge of CLK, line released at falling edge
 *     of CLK
 * - default (no option uncommented)
 *   - Data is set to 0 after hold time, line released (tCL-tSU) after
 *     last falling edge of CLK
 *
 */
//`define SUHDCHK_ZHD
`define SUHDCHK_CKFE

module stimulus 
	(
    IO,
    CLK1,
    CLK2,
		CS1n,
		CS2n,
    HBP,
    HTBSEL
	);

  inout [7:0] IO;
	
	output CS1n, CS2n;
	output CLK1, CLK2;
  output reg [2:0] HBP = 3'b000;
  output reg HTBSEL = 0;
        
	reg CSn = 1;
	reg CLK = 0;
        
	reg SI_IO0_reg=0;
  reg SO_IO1_reg=0;
  reg WPn_IO2_reg=0;
  reg IO3_reg=0;

  reg [3:0] tx;
  reg sel_dev;

  parameter SPI = 3'h1;
  parameter DPI = 3'h2;
  parameter QPI = 3'h4;

  wire SI_IO0;
  wire SO_IO1;
  wire WPn_IO2;
  wire IO3;

  /* Register Addresses */
  localparam ADDR_SR  = 32'h0;
  localparam ADDR_ISR = 32'h1;
  localparam ADDR_CR1 = 32'h2;
  localparam ADDR_CR2 = 32'h3;
  localparam ADDR_INTCR = 32'h4;
  localparam ADDR_ECCDIR = 32'h5;
  localparam ADDR_ECCEIR = 32'h6;
  localparam ADDR_ECCDOR = 32'h7;
  localparam ADDR_ECCECR = 32'h8;
  localparam ADDR_ID  = 32'h30;
  localparam ADDR_UID = 32'h40;
  localparam ADDR_SN  = 32'h50;

  `include "task.v"
  
  assign IO[0] = (tx[0] && sel_dev==1'b0) ? SI_IO0_reg : 1'bz;  
  assign IO[1] = (tx[1] && sel_dev==1'b0) ? SO_IO1_reg : 1'bz;  
  assign IO[2] = (tx[2] && sel_dev==1'b0) ? WPn_IO2_reg : 1'bz;  
  assign IO[3] = (tx[3] && sel_dev==1'b0) ? IO3_reg : 1'bz;  
  assign IO[4] = (tx[0] && sel_dev==1'b1) ? SI_IO0_reg : 1'bz;  
  assign IO[5] = (tx[1] && sel_dev==1'b1) ? SO_IO1_reg : 1'bz;  
  assign IO[6] = (tx[2] && sel_dev==1'b1) ? WPn_IO2_reg : 1'bz;  
  assign IO[7] = (tx[3] && sel_dev==1'b1) ? IO3_reg : 1'bz;  
  assign CLK1 = (sel_dev==1'b0) ? CLK : 0;
  assign CLK2 = (sel_dev==1'b1) ? CLK : 0;
  assign CS1n = (sel_dev==1'b0) ? CSn : 1'b1;
  assign CS2n = (sel_dev==1'b1) ? CSn : 1'b1;

  assign SI_IO0  = (sel_dev == 1'b0) ? IO[0] : IO[4];
  assign SO_IO1  = (sel_dev == 1'b0) ? IO[1] : IO[5];
  assign WPn_IO2 = (sel_dev == 1'b0) ? IO[2] : IO[6];
  assign IO3     = (sel_dev == 1'b0) ? IO[3] : IO[7];

  /* Initialize */
  initial begin
    SI_IO0_reg = 0;
    SO_IO1_reg = 0;
    WPn_IO2_reg = 0;
    IO3_reg = 0;
    tx = 0;
  end

  /* Expected errors : 2 */
  initial begin

    /*$display("==== [TEST] RDFT (4byte) 1-1-1, Latency 8 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08); // latency 8
    WriteEnable(SPI);
    WriteSeq(SPI, 32'h1234, 8'h31, 8'h2, 24'd10);
    FastReadSeqXIP(SPI, 32'h1234, 8'h31, 8'h2, 8'h8, 24'd10);
    $display("==== [SUBTEST] RDFT (4byte) 4-4-4, Latency 8 ====");
    QPIEnable(SPI);
    FastReadSeqXIP(QPI, 32'h1234, 8'h31, 8'h2, 8'h8, 24'd10);
    $display("==== [SUBTEST] RDFT (4byte) 1-1-1, Latency 15 ====");
    SPIEnable(QPI);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h0F); // latency 15 
    FastReadSeqXIP(SPI, 32'h1234, 8'h31, 8'h2, 8'hF, 24'd10);
    $display("==== [SUBTEST] RDFT (3byte) 1-1-1, Latency 15 ====");
    FastReadSeqXIP_24bit(SPI, 24'h1234, 8'h31, 8'h2, 8'hF, 24'd10);
    $display("==== [SUBTEST] RDFT (3byte) 4-4-4, Latency 15 ====");
    QPIEnable(SPI);
    FastReadSeqXIP_24bit(QPI, 24'h1234, 8'h31, 8'h2, 8'hF, 24'd10);
    SPIEnable(QPI);

    $display("==== [TEST] RDQO (4byte), Latency 8 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08); // latency 8
    WriteEnable(SPI);
    WriteSeq(SPI, 32'hbaba, 8'h27, 8'h3, 24'd10);
    ReadQuadOutputSeqXIP(SPI, 32'hbaba, 8'h27, 8'h3, 8'h8, 24'd10);
    $display("==== [SUBTEST] RDQO (4byte), Latency 15 ====");
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h0F); // latency 15 
    WriteEnable(SPI);
    ReadQuadOutputSeqXIP(SPI, 32'hbaba, 8'h27, 8'h3, 8'hF, 24'd10);

    $display("==== [TEST] RDQO (3byte), Latency 8 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08); // latency 8
    WriteEnable(SPI);
    WriteSeq(SPI, 32'h3192, 8'h27, 8'h3, 24'd10);
    ReadQuadOutputSeqXIP_24bit(SPI, 24'h3192, 8'h27, 8'h3, 8'h8, 24'd10);
    $display("==== [SUBTEST] RDQO (3byte), Latency 15 ====");
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h0F); // latency 15 
    WriteEnable(SPI);
    ReadQuadOutputSeqXIP_24bit(SPI, 24'h3192, 8'h27, 8'h3, 8'hF, 24'd10);

    $display("==== [TEST] RDQI, Latency 8 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08); // latency 8
    WriteEnable(SPI);
    WriteSeq(SPI, 32'hc3d0, 8'hb1, 8'h3, 24'd10);
    ReadQuadIOSeqXIP(SPI, 32'hc3d0, 8'hb1, 8'h3, 8'h8, 24'd10, 1'b0, 8'hff);
    $display("==== [SUBTEST] RDQI, Latency 15 ====");
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h0F); // latency 15 
    WriteEnable(SPI);
    ReadQuadIOSeqXIP(SPI, 32'hc3d0, 8'hb1, 8'h3, 8'hF, 24'd10, 1'b0, 8'hff);

    $display("==== [TEST] RDQI XIP, Latency 8 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08); // latency 8
    WriteEnable(SPI);
    WriteSeq(SPI, 32'hdad0, 8'h70, 8'h1, 24'd20);
    ReadQuadIOSeqXIP(SPI, 32'hdad0, 8'h70, 8'h1, 8'h8, 24'd8, 1'b0, 8'haf); // XIP on
    ReadQuadIOSeqXIP(SPI, 32'hdad8, 8'h78, 8'h1, 8'h8, 24'd2, 1'b1, 8'ha5);
    ReadQuadIOSeqXIP(SPI, 32'hdada, 8'h7a, 8'h1, 8'h8, 24'd2, 1'b1, 8'hf5); // XIP off
    ReadQuadIOSeqXIP(SPI, 32'hdadc, 8'h7c, 8'h1, 8'h8, 24'd8, 1'b0, 8'hf5);*/

    $display("==== [TEST] WRFT 1-1-1 XIP, WRENS Back-to-back ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h02); // Back-to-back
    WriteEnable(SPI);
    FastWriteSeqXIP(SPI, 32'h6600, 8'h60, 8'h1, 24'd3, 1'b0, 8'ha2); // XIP on
    FastWriteSeqXIP(SPI, 32'h6603, 8'h63, 8'h1, 24'd3, 1'b1, 8'ha7);
    FastWriteSeqXIP(SPI, 32'h6606, 8'h66, 8'h1, 24'd3, 1'b1, 8'hf7); // XIP off
    FastWriteSeqXIP(SPI, 32'h6609, 8'h69, 8'h1, 24'd3, 1'b0, 8'hf3);
    ReadSeq(SPI, 32'h6600, 8'h60, 8'h1, 24'd12);

    $display("==== [TEST] WRFT 1-1-1 XIP, WRENS Normal  ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00); // Normal
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08); // latency 8
    WriteEnable(SPI);
    FastWriteSeqXIP(SPI, 32'h6600, 8'ha0, 8'h1, 24'd3, 1'b0, 8'ha2); // XIP on
    FastWriteSeqXIP(SPI, 32'h6603, 8'ha3, 8'h1, 24'd3, 1'b1, 8'ha7);
    FastWriteSeqXIP(SPI, 32'h6606, 8'ha6, 8'h1, 24'd3, 1'b1, 8'hf7); // XIP off
    WriteEnable(SPI); // required since turning XIP off clears WREN in normal 
    FastWriteSeqXIP(SPI, 32'h6609, 8'ha9, 8'h1, 24'd3, 1'b0, 8'hf3);
    //ReadSeq(SPI, 32'h6600, 8'ha0, 8'h1, 24'd12);
    ReadQuadIOSeqXIP(SPI, 32'h6600, 8'ha0, 8'h1, 8'h8, 24'd3, 1'b0, 8'haf); // XIP on
    ReadQuadIOSeqXIP(SPI, 32'h6603, 8'ha3, 8'h1, 8'h8, 24'd2, 1'b1, 8'ha5);
    ReadQuadIOSeqXIP(SPI, 32'h6605, 8'ha5, 8'h1, 8'h8, 24'd2, 1'b1, 8'hf5); // XIP off
    ReadQuadIOSeqXIP(SPI, 32'h6607, 8'ha7, 8'h1, 8'h8, 24'd5, 1'b0, 8'hf5);

    $display("==== [TEST] WRFT 1-1-1 XIP, WRENS SRAM mode ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h01); // SRAM mode
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08); // latency 8
    WriteEnable(SPI);
    FastWriteSeqXIP(SPI, 32'h6600, 8'h60, 8'h1, 24'd3, 1'b0, 8'ha2); // XIP on
    FastWriteSeqXIP(SPI, 32'h6603, 8'h63, 8'h1, 24'd3, 1'b1, 8'ha7);
    FastWriteSeqXIP(SPI, 32'h6606, 8'h66, 8'h1, 24'd3, 1'b1, 8'hf7); // XIP off
    FastWriteSeqXIP(SPI, 32'h6609, 8'h69, 8'h1, 24'd3, 1'b0, 8'hf3);
    ReadQuadIOSeqXIP(SPI, 32'h6600, 8'h60, 8'h1, 8'h8, 24'd3, 1'b0, 8'haf); // XIP on
    ReadQuadIOSeqXIP(SPI, 32'h6603, 8'h63, 8'h1, 8'h8, 24'd2, 1'b1, 8'ha5);
    ReadQuadIOSeqXIP(SPI, 32'h6605, 8'h65, 8'h1, 8'h8, 24'd2, 1'b1, 8'hf5); // XIP off
    ReadQuadIOSeqXIP(SPI, 32'h6607, 8'h67, 8'h1, 8'h8, 24'd5, 1'b0, 8'hf5);

    /*$display("==== [TEST] WRFT 4-4-4 XIP ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h02); // Back-to-back
    WriteEnable(SPI);
    QPIEnable(SPI);
    FastWriteSeqXIP(QPI, 32'h7700, 8'h60, 8'h1, 24'd3, 1'b0, 8'ha2); // XIP on
    FastWriteSeqXIP(QPI, 32'h7703, 8'h63, 8'h1, 24'd3, 1'b1, 8'ha7);
    FastWriteSeqXIP(QPI, 32'h7706, 8'h66, 8'h1, 24'd3, 1'b1, 8'hf7); // XIP off
    FastWriteSeqXIP(QPI, 32'h7709, 8'h69, 8'h1, 24'd3, 1'b0, 8'hf3);
    SPIEnable(QPI);
    ReadSeq(SPI, 32'h7700, 8'h60, 8'h1, 24'd12);

    $display("==== [TEST] WQIO 1-4-4 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00);
    WriteEnable(SPI);
    WriteQuadIOSeqXIP(SPI, 32'h3578, 8'h38, 8'h3, 24'd10, 1'b0, 8'hff);
    ReadSeq(SPI, 32'h3578, 8'h38, 8'h3, 24'd10);

    $display("==== [TEST] WQIO 1-4-4 XIP ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h02); // Back-to-back
    WriteEnable(SPI);
    WriteQuadIOSeqXIP(SPI, 32'h1300, 8'h60, 8'h1, 24'd3, 1'b0, 8'ha2); // XIP on
    WriteQuadIOSeqXIP(SPI, 32'h1303, 8'h63, 8'h1, 24'd3, 1'b1, 8'ha7);
    WriteQuadIOSeqXIP(SPI, 32'h1306, 8'h66, 8'h1, 24'd3, 1'b1, 8'hf7); // XIP off
    WriteQuadIOSeqXIP(SPI, 32'h1309, 8'h69, 8'h1, 24'd3, 1'b0, 8'hf3);
    ReadSeq(SPI, 32'h1300, 8'h60, 8'h1, 24'd12);*/

    $finish;

  end
endmodule
